// This file is part of Cross Domain extension for firefox
// 12 june 2007
// author : Alexandre Vautier

// Texttomap is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// Texttomap is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with Cross Domain.  If not, see <http://www.gnu.org/licenses/>.

//Cross Domain Web Api Version 0.3

function CrossDomain(listener, JSONparseArg, JSONstringifyArg)
{
	this.JSONparse = JSONparseArg;
	this.JSONstringify = JSONstringifyArg;

	this.isExtensionPresent = function(actionId) 
	{
		var element = document.createElement("MyExtensionDataElement");
		element.setAttribute("actionId", actionId);
		element.setAttribute("action", "testExtensionPresence");
		element.setAttribute("args", "");
		element.setAttribute("url", document.documentURI);
		document.documentElement.appendChild(element);

		var evt = document.createEvent("Events");
		evt.initEvent("CrossDomainEvent", true, false);
		//console.log("isExtensionPresent sent");
		element.dispatchEvent(evt);		
	}

	this.loadHtmlUrl = function(actionId, url) 
	{
		//console.log("javascript.loadHtmlUrl(" + actionId + "," + url + ")");
		var element = document.createElement("MyExtensionDataElement");
		element.setAttribute("action", "download");
		element.setAttribute("actionId", actionId);
		element.setAttribute("args", url);
		element.setAttribute("url", document.documentURI);
		document.documentElement.appendChild(element);
	
		var evt = document.createEvent("Events");
		evt.initEvent("CrossDomainEvent", true, false);
		element.dispatchEvent(evt);
	}; 
	
	this.parseUrl = function(actionId, url, pattern) 
	{
		//console.log("javascript.parseUrl(" + actionId + "," + url + ",...)");
		var element = document.createElement("MyExtensionDataElement");
		var argObject = {};
		argObject.Pattern = pattern;
		argObject.Url = url;
		
		var args = this.JSONstringify(argObject);
		
		element.setAttribute("action", "downloadAndParse");
		element.setAttribute("actionId", actionId);
		element.setAttribute("args", args);
		element.setAttribute("url", document.documentURI);
		document.documentElement.appendChild(element);
	
		var evt = document.createEvent("Events");
		evt.initEvent("CrossDomainEvent", true, false);
		element.dispatchEvent(evt);
	};
	
	this.myeventListener = function(event)
	{
		//console.log("myeventListener start");
		var elm = event.target;
		var att = elm.getAttribute("onmyevent");
		//*** attribute "myextra" is set in extension code
		var jsonMyextra = elm.getAttribute("myextra");
		//console.log("jsonMyextra : " + jsonMyextra);		
		var myextra = this.JSONparse(jsonMyextra);		

		//*** clean up
		if (elm.hasAttribute("myextra"))
		{
			elm.removeAttribute("myextra");	
		}		  
			  
 	    //console.log("myextra.actionId : " + myextra.actionId);
 	    
 	    var array = this.JSONparse(myextra.text);
 	    
		this.listener(myextra.actionId,array);	  
	};
	
	this.listener = listener;
	var obj = this;
	document.addEventListener("myevent",function(event){obj.myeventListener(event);}, false, true);			

	var p = document.createElement("div");
	//p.setAttribute("id","browser_listener");
	p.id = "browser_listener";	
	document.getElementsByTagName("body")[0].appendChild(p);
	
	//console.log("CrossDomain initialized");
}